pub mod serialization {
    pub use serialization::libflo_serde::LibfloSerde;

    mod libflo_serde {
        use libflo_dynamic_event::serialization::DynamicEventMapperSerde;
        use libflo_func::serialization::FuncMapperSerde;
        use libflo_module::serialization::ModuleMapperSerde;

        #[derive(Clone, Debug, Eq, PartialEq, Serialize)]
        pub struct LibfloSerde<'a, 'b, 'c> {
            dynamic_event_mapper: DynamicEventMapperSerde<'a>,
            func_mapper: FuncMapperSerde<'b>,
            module_mapper: ModuleMapperSerde<'c>,
        }

        impl <'a, 'b, 'c> LibfloSerde<'a, 'b, 'c> {
            pub fn new(
                dynamic_event_mapper: DynamicEventMapperSerde<'a>,
                func_mapper: FuncMapperSerde<'b>,
                module_mapper: ModuleMapperSerde<'c>,
            ) -> Self {
                LibfloSerde {
                    dynamic_event_mapper: dynamic_event_mapper,
                    func_mapper: func_mapper,
                    module_mapper: module_mapper,
                }
            }
        }
    }
}
