use libflo_error::{ Result as FuncResult, WrapErr };
use serde_json;
use static_libflo::STATIC_LIBFLO;

#[no_mangle]
pub extern fn get_file_from_submodules(get_file_from_submodules_params: &str) -> FuncResult<String> {
    let libflo = STATIC_LIBFLO.get().wrap_err_to_err()?;
    let path_resolver = libflo.get_path_resolver();

    let (file, submodule_id, module_ids): (String, usize, Vec<usize>) =
        serde_json::from_str(&get_file_from_submodules_params).wrap_err_to_err()?;

    let mut result = Vec::new();
    for module_id in module_ids {
        let path = path_resolver.find_submodule_file_path(&file, module_id, submodule_id).wrap_err_to_err()?;
        let path_string = path.to_string_lossy().into_owned();
        result.push((module_id, path_string));
    }

    let result = serde_json::to_string(&result).wrap_err_to_err()?;
    Ok(result)
}
