use libflo_error::{ Result as FuncResult, WrapErr };
use serde_json;
use static_libflo::STATIC_LIBFLO;
use std::fs;

#[no_mangle]
pub extern fn get_file_from_submodule(get_file_from_submodule_params: &str) -> FuncResult<String> {
    let libflo = STATIC_LIBFLO.get().wrap_err_to_err()?;
    let path_resolver = libflo.get_path_resolver();

    let (file, submodule_id, module_id): (String, usize, usize) =
        serde_json::from_str(&get_file_from_submodule_params).wrap_err_to_err()?;

    let path = path_resolver.find_submodule_file_path(&file, module_id, submodule_id).wrap_err_to_err()?;
    let absolute_path = fs::canonicalize(path).wrap_err_to_err()?;
    let result = absolute_path.to_string_lossy().into_owned();

    Ok(result)
}
