use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__token", GLOBAL_NS)
}

pub fn token(options: &Options) -> String {
    format!(
        "
// Token
{token_blob} {fn_attributes} {ns}__new(
    uint32_t token_type,
    {bytes_blob} token_value_blob,
    {loc_blob} loc_blob,
    uint32_t lex_state_before,
    uint32_t lex_state_after);
void {fn_attributes} {ns}__drop({token_blob} *self_blob);
uint32_t {fn_attributes} {ns}__get_token_type(const {token_blob} *self_blob);
const {bytes_blob} *{fn_attributes} {ns}__get_token_value(const {token_blob} *self_blob);
void {fn_attributes} {ns}__set_token_value({token_blob} *self_blob, {bytes_blob} token_value_blob);
{bytes_blob} {fn_attributes} {ns}__into_token_value({token_blob} self_blob);
const {loc_blob} *{fn_attributes} {ns}__get_loc(const {token_blob} *self_blob);
uint32_t {fn_attributes} {ns}__get_lex_state_before(const {token_blob} *self_blob);
uint32_t {fn_attributes} {ns}__get_lex_state_after(const {token_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        token_blob = options.token_blob_name,
        bytes_blob = options.bytes_blob_name,
        loc_blob = options.loc_blob_name,
    )
}
