use super::fields;
use crate::Options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the internal struct representing given `node`
pub fn name(node: &Node) -> String {
    format!("Internal{}", node.camelcase_name)
}

/// Returns definition of the internal struct representing given `node`
pub fn definition(node: &Node, options: &Options) -> String {
    let fields = node.fields.map(|field| {
        format!(
            "{} {};",
            fields::field_type(field, options),
            fields::field_name(field)
        )
    });

    format!(
        "typedef struct {internal_struct_name}
{{
    {fields}
}} {internal_struct_name};",
        internal_struct_name = name(node),
        fields = fields.join("\n    ")
    )
}
