/// Returns namespace of all functions related to nodes
pub fn ns() -> String {
    format!("{}__nodes", crate::NS)
}

/// Mod with functions for building constructors of nodes
pub mod constructor;
/// Mod with functions for building destructors of nodes
pub mod drop_variant;
/// Mod with functions for building field getters of nodes
pub mod field_getter;
/// Mod with functions for building field setters of nodes
pub mod field_setter;
/// Mod with utility functions to get name and type of the node field
pub mod fields;
/// Mod with functions for building internal structs of nodes
/// (used pretty much like move ctors)
pub mod internal_struct;
/// Mod with functions for building into-internal functions of nodes
pub mod into_internal;
/// Mod with functions for building into-variant functions of nodes
pub mod into_variant;
/// Mod with functions for building cast-to-variant functions of nodes
pub mod variant_getter;
/// Mod with functions for building is-a-variant functions of nodes
pub mod variant_predicate;
