use super::ns;
use crate::Options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the is-a-variant function for the given `node`
pub fn name(node: &Node) -> String {
    format!("{ns}__is_{lower}", ns = ns(), lower = node.lower_name())
}

/// Returns name of the is-a-variant function for the given `node`
pub fn sig(node: &Node, options: &Options) -> String {
    format!(
        "bool {variant_predicate_name}(const {node_blob}* self_blob)",
        variant_predicate_name = name(node),
        node_blob = options.node_blob_name
    )
}
