use super::{internal_struct, ns};
use crate::Options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the cast-into-internal fn for the given `node`
pub fn name(node: &Node) -> String {
    format!(
        "{ns}__{lower}__into_internal",
        ns = ns(),
        lower = node.lower_name()
    )
}

/// Returns C signature of the cast-into-internal fn for the given `node`
pub fn sig(node: &Node, options: &Options) -> String {
    format!(
        "{internal_struct_name} {fn_name}({node_variant_blob} self_blob)",
        internal_struct_name = internal_struct::name(node),
        node_variant_blob = options.node_variant_blob_name(node),
        fn_name = name(node)
    )
}
