use super::ns;
use crate::Options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the destructor for the given `node`
pub fn name(node: &Node) -> String {
    format!("{ns}__{lower}__drop", ns = ns(), lower = node.lower_name())
}

/// Returns name of the destructor for the given `node`
pub fn sig(node: &Node, options: &Options) -> String {
    format!(
        "void {fn_name}({node_variant_blob} *self_blob)",
        fn_name = name(node),
        node_variant_blob = options.node_variant_blob_name(node),
    )
}
