use super::ns;
use crate::Options;
use lib_ruby_parser_nodes::Message;

/// Returns name of the is-a-variant function for the given `message`
pub fn name(message: &Message) -> String {
    format!(
        "{ns}__is_{variant}",
        ns = ns(),
        variant = message.lower_name()
    )
}

/// Returns name of the is-a-variant function for the given `message`
pub fn sig(message: &Message, options: &Options) -> String {
    format!(
        "bool {variant_predicate_name}(const {diagnostic_message_blob} *self_blob)",
        variant_predicate_name = name(message),
        diagnostic_message_blob = options.diagnostic_message_blob_name
    )
}
