use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__ptr", GLOBAL_NS)
}

pub fn ptr(options: &Options) -> String {
    format!(
        "
// Ptr
{ptr_blob} {ns}__new(void *ptr);
void {ns}__of_node__drop({ptr_blob} *self_blob);
void {ns}__of_token__drop({ptr_blob} *self_blob);
void *{ns}__get_raw({ptr_blob} *self_blob);
",
        ns = ns(),
        ptr_blob = options.ptr_blob_name
    )
}
