use crate::{helpers, Options, NS as GLOBAL_NS};
use lib_ruby_parser_nodes::{messages, Message};

pub fn message(options: &Options) -> String {
    format!(
        "
// DiagnosticMessage
{constructors}

{variant_getters}

{variant_predicates}

{field_getters}

void {ns}__diagnostic_message__drop({diagnostic_message_blob} *self_blob);
",
        ns = GLOBAL_NS,
        constructors = constructors(options),
        variant_getters = variant_getters(options),
        variant_predicates = variant_predicates(options),
        field_getters = field_getters(options),
        diagnostic_message_blob = options.diagnostic_message_blob_name
    )
}

fn constructors(options: &Options) -> String {
    map_messages_to_sigs(options, &helpers::messages::constructor::sig)
}
fn variant_getters(options: &Options) -> String {
    map_messages_to_sigs(options, &helpers::messages::variant_getter::sig)
}
fn variant_predicates(options: &Options) -> String {
    map_messages_to_sigs(options, &helpers::messages::variant_predicate::sig)
}
fn field_getters(options: &Options) -> String {
    messages()
        .flat_map(&|message| {
            message.fields.map(&|field| {
                format!(
                    "{signature};",
                    signature = helpers::messages::field_getter::sig(message, field, options)
                )
            })
        })
        .join("\n")
}

fn map_messages_to_sigs(
    options: &Options,
    sig_fn: &dyn Fn(&Message, &Options) -> String,
) -> String {
    messages()
        .map(&|message| format!("{sig};", sig = sig_fn(message, options)))
        .join("\n")
}
