use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe_ptr", GLOBAL_NS)
}

pub fn maybe_ptr(options: &Options) -> String {
    format!(
        "
// MaybePtr
{maybe_ptr_blob} {ns}__new(void *raw);
{maybe_ptr_blob} {ns}__new_null();
void {ns}__of_node__drop({maybe_ptr_blob} *self_blob);
void {ns}__of_token__drop({maybe_ptr_blob} *self_blob);
void *{ns}__get_raw({maybe_ptr_blob} *self_blob);
",
        ns = ns(),
        maybe_ptr_blob = options.maybe_ptr_blob_name,
    )
}
