use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__magic_comment", GLOBAL_NS)
}

pub fn magic_comment(options: &Options) -> String {
    format!(
        "
// MagicComment
{magic_comment_blob} {ns}__new(
    {magic_comment_kind_blob} kind_blob,
    {loc_blob} key_l_blob,
    {loc_blob} value_l_blob);
void {ns}__drop({magic_comment_blob} *self_blob);
const {magic_comment_kind_blob} *{ns}__get_kind(const {magic_comment_blob} *self_blob);
const {loc_blob} *{ns}__get_key_l(const {magic_comment_blob} *self_blob);
const {loc_blob} *{ns}__get_value_l(const {magic_comment_blob} *self_blob);
",
        ns = ns(),
        magic_comment_blob = options.magic_comment_blob_name,
        magic_comment_kind_blob = options.magic_comment_kind_blob_name,
        loc_blob = options.loc_blob_name,
    )
}
