use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__input_error", GLOBAL_NS)
}

pub fn input_error(options: &Options) -> String {
    format!(
        "
// InputError
{input_error_blob} {ns}__new_unsupported_encoding({string_ptr_blob} err_blob);
{input_error_blob} {ns}__new_decoding_error({string_ptr_blob} err_blob);
void {ns}__drop({input_error_blob}* self_blob);
bool {ns}__is_unsupported_encoding(const {input_error_blob}* self_blob);
bool {ns}__is_decoding_error(const {input_error_blob}* self_blob);
const {string_ptr_blob} *{ns}__get_unsupported_encoding(const {input_error_blob}* self_blob);
const {string_ptr_blob} *{ns}__get_decoding_error(const {input_error_blob}* self_blob);
",
        ns = ns(),
        input_error_blob = options.input_error_blob_name,
        string_ptr_blob = options.string_ptr_blob_name
    )
}
