use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__decoded_input", GLOBAL_NS)
}

pub fn decoded_input(options: &Options) -> String {
    format!(
        "
// DecodedInput
{decoded_input_blob} {ns}__new(
    {string_ptr_blob} name_blob,
    {source_line_list_blob} lines_blob,
    {byte_list_blob} bytes_blob);
void {ns}__drop({decoded_input_blob}* self_blob);
const {string_ptr_blob} *{ns}__get_name(const {decoded_input_blob} *self_blob);
const {source_line_list_blob} *{ns}__get_lines(const {decoded_input_blob} *self_blob);
const {byte_list_blob} *{ns}__get_bytes(const {decoded_input_blob} *self_blob);
void {ns}__set_name({decoded_input_blob} *self_blob, {string_ptr_blob} name_blob);
void {ns}__set_lines({decoded_input_blob} *self_blob, {source_line_list_blob} lines_blob);
void {ns}__set_bytes({decoded_input_blob} *self_blob, {byte_list_blob} bytes_blob);
{byte_list_blob} {ns}__into_bytes({decoded_input_blob} self_blob);
{byte_list_blob} {ns}__take_bytes({decoded_input_blob} *self_blob);
",
        ns = ns(),
        decoded_input_blob = options.decoded_input_blob_name,
        string_ptr_blob = options.string_ptr_blob_name,
        source_line_list_blob = options.source_line_list_blob_name,
        byte_list_blob = options.byte_list_blob_name,
    )
}
