use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__bytes", GLOBAL_NS)
}

pub fn bytes(options: &Options) -> String {
    format!(
        "
// Bytes
{bytes_blob} {ns}__new({byte_list_blob} raw_blob);
void {ns}__drop({bytes_blob} *self_blob);
const {byte_list_blob} *{ns}__get_raw(const {bytes_blob} *self_blob);
void {ns}__set_raw({bytes_blob} *self_blob, {byte_list_blob} raw_blob);
{byte_list_blob} {ns}__into_raw({bytes_blob} self_blob);
void {ns}__push({bytes_blob} *self_blob, {byte_blob} byte_blob);
",
        ns = ns(),
        bytes_blob = options.bytes_blob_name,
        byte_list_blob = options.byte_list_blob_name,
        byte_blob = options.byte_blob_name
    )
}
