### lib-ruby-parser-bindings

[![test](https://github.com/lib-ruby-parser/lib-ruby-parser-bindings/workflows/test/badge.svg?branch=master)](https://github.com/lib-ruby-parser/lib-ruby-parser-bindings/actions?query=workflow%3Atest)
[![unsafe forbidden](https://img.shields.io/badge/unsafe-forbidden-success.svg)](https://github.com/rust-secure-code/safety-dance/)
[![Crates.io](https://img.shields.io/crates/v/lib-ruby-parser-bindings?color=orange)](https://crates.io/crates/lib-ruby-parser-bindings)
[![MIT Licence](https://badges.frapsoft.com/os/mit/mit.svg?v=103)](https://opensource.org/licenses/mit-license.php)
[![dependency status](https://deps.rs/repo/github/lib-ruby-parser/lib-ruby-parser-bindings/status.svg)](https://deps.rs/repo/github/lib-ruby-parser/lib-ruby-parser-bindings)
[![Docs](https://img.shields.io/docsrs/lib-ruby-parser-bindings)](https://docs.rs/lib-ruby-parser-bindings)


This crate contains shared scripts to build bindings to `lib-ruby-parser`.

## Examples

```rust
use lib_ruby_parser_bindings::{generate, Options};

let options = Options {
    pre_code: String::from("#include \"stubs.h\""),
    ..Default::default()
};
let contents = generate(&options);

std::fs::write("codegen/bindings.h", contents).unwrap();
```
