use super::fields;
use lib_ruby_parser_nodes::Node;

/// Returns name of the internal struct representing given `node`
pub fn name(node: &Node) -> String {
    format!("Internal{}", node.camelcase_name)
}

/// Returns definition of the internal struct representing given `node`
pub fn definition(node: &Node) -> String {
    let fields = node
        .fields
        .iter()
        .map(|field| {
            format!(
                "{} {};",
                fields::field_type(field),
                fields::field_name(field)
            )
        })
        .collect::<Vec<_>>();

    format!(
        "typedef struct {internal_struct_name}
{{
    {fields}
}} {internal_struct_name};",
        internal_struct_name = name(node),
        fields = fields.join("\n    ")
    )
}
