use super::ns;
use crate::options;
use lib_ruby_parser_nodes::Message;

/// Returns name of the cast-to-variant function for the given `message`
pub fn name(message: &Message) -> String {
    format!(
        "{ns}__as_{variant}",
        ns = ns(),
        variant = message.lower_name()
    )
}

/// Returns C signature of the cast-to-variant function for the given `message`
pub fn sig(message: &Message) -> String {
    format!(
        "const {message_variant_blob} *{fn_attributes} {variant_getter_name}(const {diagnostic_message_blob} *self_blob)",
        message_variant_blob = options().message_variant_blob_name(message),
        fn_attributes = options().fn_attributes,
        variant_getter_name = name(message),
        diagnostic_message_blob = options().diagnostic_message_blob_name
    )
}
