use crate::{helpers, options, NS as GLOBAL_NS};
use lib_ruby_parser_nodes::{template::*, Node, NodeField};

const TEMPLATE: &str = "
// Node

// Node constructors
{{ each node }}<dnl>
{{ helper node-constructor }};
{{ end }}

// Node variant predicates
{{ each node }}<dnl>
{{ helper node-variant-predicate }};
{{ end }}

// Node variant getter
{{ each node }}<dnl>
{{ helper node-variant-getter }};
{{ end }}

// Node field getters
{{ each node }}<dnl>
{{ each node-field }}<dnl>
{{ helper node-field-getter }};
{{ end }}
{{ end }}

// Node field setters
{{ each node }}<dnl>
{{ each node-field }}<dnl>
{{ helper node-field-setter }};
{{ end }}
{{ end }}

#ifdef __cplusplus
extern \"C\" {
#endif

{{ each node }}<dnl>
{{ helper internal-struct-definition }}
{{ end }}

#ifdef __cplusplus
}
#endif

// into_variant fns
{{ each node }}<dnl>
{{ helper into-variant }};
{{ end }}

// into_internal fns
{{ each node }}<dnl>
{{ helper into-internal }};
{{ end }}

// variant drop fns
{{ each node }}<dnl>
{{ helper drop-variant }};
{{ end }}

void {{ helper fn-attributes }} {{ helper ns }}__node__drop({{ helper node-blob }}* self_blob);
";

pub fn node() -> String {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = TemplateFns::new();
    fns.register::<Node, F::Helper>("node-constructor", helpers::nodes::constructor::sig);
    fns.register::<Node, F::Helper>(
        "node-variant-predicate",
        helpers::nodes::variant_predicate::sig,
    );
    fns.register::<Node, F::Helper>("node-variant-getter", helpers::nodes::variant_getter::sig);
    fns.register::<NodeField, F::Helper>("node-field-getter", helpers::nodes::field_getter::sig);
    fns.register::<NodeField, F::Helper>("node-field-setter", helpers::nodes::field_setter::sig);
    fns.register::<Node, F::Helper>(
        "internal-struct-definition",
        helpers::nodes::internal_struct::definition,
    );
    fns.register::<Node, F::Helper>("into-variant", helpers::nodes::into_variant::sig);
    fns.register::<Node, F::Helper>("into-internal", helpers::nodes::into_internal::sig);
    fns.register::<Node, F::Helper>("drop-variant", helpers::nodes::drop_variant::sig);

    fn fn_attributes(_: &GlobalContext) -> String {
        options().fn_attributes.to_string()
    }
    fns.register::<GlobalContext, F::Helper>("fn-attributes", fn_attributes);

    fn ns(_: &GlobalContext) -> String {
        GLOBAL_NS.to_string()
    }
    fns.register::<GlobalContext, F::Helper>("ns", ns);

    fn node_blob(_: &GlobalContext) -> String {
        options().node_blob_name.to_string()
    }
    fns.register::<GlobalContext, F::Helper>("node-blob", node_blob);

    template.render(ALL_DATA, &fns)
}
