use crate::{helpers, options, NS as GLOBAL_NS};
use lib_ruby_parser_nodes::{template::*, Message, MessageField};

const TEMPLATE: &str = "
// DiagnosticMessage
{{ each message }}<dnl>
{{ helper message-constructor }};
{{ end }}

// variant getters
{{ each message }}<dnl>
{{ helper variant-getter }};
{{ end }}

// variant predicates
{{ each message }}<dnl>
{{ helper variant-predicate }};
{{ end }}

// field getters
{{ each message }}<dnl>
{{ each message-field }}<dnl>
{{ helper field-getter }};
{{ end }}<dnl>
{{ end }}<dnl>

void {{ helper fn-attributes }} {{ helper ns }}__diagnostic_message__drop({{ helper message-blob }} *self_blob);
";

pub fn message() -> String {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = TemplateFns::new();
    fns.register::<Message, F::Helper>("message-constructor", helpers::messages::constructor::sig);
    fns.register::<Message, F::Helper>("variant-getter", helpers::messages::variant_getter::sig);
    fns.register::<Message, F::Helper>(
        "variant-predicate",
        helpers::messages::variant_predicate::sig,
    );
    fns.register::<MessageField, F::Helper>("field-getter", helpers::messages::field_getter::sig);

    fn fn_attributes(_: &GlobalContext) -> String {
        options().fn_attributes.to_string()
    }
    fns.register::<GlobalContext, F::Helper>("fn-attributes", fn_attributes);

    fn ns(_: &GlobalContext) -> String {
        GLOBAL_NS.to_string()
    }
    fns.register::<GlobalContext, F::Helper>("ns", ns);

    fn message_blob(_: &GlobalContext) -> String {
        options().diagnostic_message_blob_name.to_string()
    }
    fns.register::<GlobalContext, F::Helper>("message-blob", message_blob);

    template.render(ALL_DATA, &fns)
}
