use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__comment_type", GLOBAL_NS)
}
pub fn comment_type() -> String {
    format!(
        "
// CommentType
{comment_type_blob} {fn_attributes} {ns}__new_inline();
{comment_type_blob} {fn_attributes} {ns}__new_document();
{comment_type_blob} {fn_attributes} {ns}__new_unknown();
void {fn_attributes} {ns}__drop({comment_type_blob} *self_blob);
bool {fn_attributes} {ns}__is_inline(const {comment_type_blob} *self_blob);
bool {fn_attributes} {ns}__is_document(const {comment_type_blob} *self_blob);
bool {fn_attributes} {ns}__is_unknown(const {comment_type_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        comment_type_blob = options().comment_type_blob_name
    )
}
