use super::{fields, ns};
use crate::options;
use lib_ruby_parser_nodes::NodeWithField;

/// Returns name of the node field setter for the given `node`/`field` pair
pub fn name(node: &NodeWithField) -> String {
    format!(
        "{ns}__{lower}__set_{field_name}",
        ns = ns(),
        lower = node.node.lower_name(),
        field_name = node.field.snakecase_name,
    )
}

/// Returns C signature of the node field setter for the given `node`/`field` pair
pub fn sig(node: &NodeWithField) -> String {
    format!(
        "void {fn_attributes} {setter_name}({node_variant_blob}* self_blob, {value_blob_type} {field_name}_blob)",
        fn_attributes = options().fn_attributes,
        setter_name = name(node),
        node_variant_blob = options().node_variant_blob_name(&node.node),
        value_blob_type = fields::field_type(&node. field),
        field_name = fields::field_name(&node. field)
    )
}
