use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    GLOBAL_NS.to_string()
}

pub fn token_rewriter() -> String {
    format!(
        "
// RewriteAction
void {fn_attributes} {ns}__rewrite_action__drop({rewrite_action_blob} *self_blob);
bool {fn_attributes} {ns}__rewrite_action__is_drop(const {rewrite_action_blob} *self_blob);
bool {fn_attributes} {ns}__rewrite_action__is_keep(const {rewrite_action_blob} *self_blob);

// LexStateAction
void {fn_attributes} {ns}__lex_state_action__drop({lex_state_action_blob} *self_blob);
bool {fn_attributes} {ns}__lex_state_action__is_set(const {lex_state_action_blob} *self_blob);
bool {fn_attributes} {ns}__lex_state_action__is_keep(const {lex_state_action_blob} *self_blob);
int32_t {fn_attributes} {ns}__lex_state_action__get_next_state(const {lex_state_action_blob} *self_blob);

// TokenRewriterResult
void {fn_attributes} {ns}__token_rewriter_result__drop({token_rewriter_result_blob} *self_blob);

#ifdef __cplusplus
extern \"C\" {{
#endif

typedef struct InternalTokenRewriterResult {{
    {ptr_blob} rewritten_token;
    {rewrite_action_blob} token_action;
    {lex_state_action_blob} lex_state_action;
}} InternalTokenRewriterResult;

#ifdef __cplusplus
}}
#endif

InternalTokenRewriterResult {fn_attributes} {ns}__token_rewriter_result__into_internal({token_rewriter_result_blob} self_blob);

// TokenRewriter
void {fn_attributes} {ns}__token_rewriter__drop({token_rewriter_blob} *self_blob);
{token_rewriter_result_blob} {fn_attributes} {ns}__token_rewriter__call(
    {token_rewriter_blob} *self_blob,
    {ptr_blob} token_blob,
    {shared_byte_list_blob} input_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        rewrite_action_blob = options().rewrite_action_blob_name,
        lex_state_action_blob = options().lex_state_action_blob_name,
        ptr_blob = options().ptr_blob_name,
        token_rewriter_result_blob = options().token_rewriter_result_blob_name,
        token_rewriter_blob = options().token_rewriter_blob_name,
        shared_byte_list_blob = options().shared_byte_list_blob_name
    )
}
