use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__parser_options", GLOBAL_NS)
}

pub fn parser_options() -> String {
    format!(
        "
// ParserOptions
{parser_options_blob} {fn_attributes} {ns}__new(
    {string_ptr_blob} buffer_name_blob,
    {maybe_decoder_blob} decoder_blob,
    {maybe_token_rewriter_blob} token_rewriter_blob,
    bool record_tokens);
void {fn_attributes} {ns}__drop({parser_options_blob} *self_blob);

#ifdef __cplusplus
extern \"C\" {{
#endif

typedef struct InternalParserOptions {{
    {string_ptr_blob} buffer_name;
    {maybe_decoder_blob} decoder;
    {maybe_token_rewriter_blob} token_rewriter;
    bool record_tokens;
}} InternalParserOptions;

#ifdef __cplusplus
}}
#endif

InternalParserOptions {fn_attributes} {ns}__into_internal({parser_options_blob} self_blob);
const {string_ptr_blob} *{fn_attributes} {ns}__get_buffer_name(const {parser_options_blob} *self_blob);
const {maybe_decoder_blob} *{fn_attributes} {ns}__get_decoder(const {parser_options_blob} *self_blob);
const {maybe_token_rewriter_blob} *{fn_attributes} {ns}__get_token_rewriter(const {parser_options_blob} *self_blob);
bool {fn_attributes} {ns}__get_record_tokens(const {parser_options_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        parser_options_blob = options().parser_options_blob_name,
        string_ptr_blob = options().string_ptr_blob_name,
        maybe_decoder_blob = options().maybe_decoder_blob_name,
        maybe_token_rewriter_blob = options().maybe_token_rewriter_blob_name
    )
}
