use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__magic_comment_kind", GLOBAL_NS)
}

pub fn magic_comment_kind() -> String {
    format!(
        "
// MagicCommentKind
{magic_comment_kind_blob} {fn_attributes} {ns}__new_encoding();
{magic_comment_kind_blob} {fn_attributes} {ns}__new_frozen_string_literal();
{magic_comment_kind_blob} {fn_attributes} {ns}__new_warn_indent();
{magic_comment_kind_blob} {fn_attributes} {ns}__new_shareable_constant_value();
void {fn_attributes} {ns}__drop({magic_comment_kind_blob}* self_blob);
bool {fn_attributes} {ns}__is_encoding(const {magic_comment_kind_blob} *self_blob);
bool {fn_attributes} {ns}__is_frozen_string_literal(const {magic_comment_kind_blob} *self_blob);
bool {fn_attributes} {ns}__is_warn_indent(const {magic_comment_kind_blob} *self_blob);
bool {fn_attributes} {ns}__is_shareable_constant_value(const {magic_comment_kind_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        magic_comment_kind_blob = options().magic_comment_kind_blob_name
    )
}
