use super::{fields, ns};
use crate::options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the constructor for the given `node`
pub fn name(node: &Node) -> String {
    format!("{ns}__new_{lower}", ns = ns(), lower = node.lower_name())
}

fn arglist(node: &Node) -> String {
    node.fields
        .map(|field| {
            format!(
                "{field_type} {name}_blob",
                field_type = fields::field_type(field),
                name = fields::field_name(field)
            )
        })
        .join(", ")
}

/// Returns C signature of the constructor for the given `node`
pub fn sig(node: &Node) -> String {
    format!(
        "{node_blob} {fn_attributes} {constructor_name}({arglist})",
        node_blob = options().node_blob_name,
        fn_attributes = options().fn_attributes,
        constructor_name = name(node),
        arglist = arglist(node)
    )
}
