use super::{fields, ns};
use crate::options;
use lib_ruby_parser_nodes::MessageWithField;

/// Returns name of the field getter for the given `message`/`field` pair
pub fn name(message: &MessageWithField) -> String {
    format!(
        "{ns}__{variant}__get_{field_name}",
        ns = ns(),
        variant = message.message.lower_name(),
        field_name = fields::field_name(&message.field)
    )
}

/// Returns C signature of the field getter for the given `message`/`field` pair
pub fn sig(message: &MessageWithField) -> String {
    format!(
        "const {return_type} *{fn_attributes} {getter_name}(const {message_variant_blob} *self_blob)",
        return_type = fields::field_type(&message.field),
        fn_attributes = options().fn_attributes,
        getter_name = name(message),
        message_variant_blob = options().message_variant_blob_name(&message.message),
    )
}
