use crate::{helpers, options, NS as GLOBAL_NS};
use lib_ruby_parser_nodes::template::*;

const TEMPLATE: &str = "
// DiagnosticMessage
<each-message><dnl>
<helper message-constructor>;
</each-message>

// variant getters
<each-message><dnl>
<helper variant-getter>;
</each-message>

// variant predicates
<each-message><dnl>
<helper variant-predicate>;
</each-message>

// field getters
<each-message><dnl>
<each-message-field><dnl>
<helper field-getter>;
</each-message-field><dnl>
</each-message><dnl>

void <helper fn-attributes> <helper ns>__diagnostic_message__drop(<helper message-blob> *self_blob);
";

pub fn message() -> String {
    let template = TemplateRoot::new(TEMPLATE).unwrap();
    let mut fns = TemplateFns::new();
    fns.register_helper("message-constructor", helpers::messages::constructor::sig);
    fns.register_helper("variant-getter", helpers::messages::variant_getter::sig);
    fns.register_helper(
        "variant-predicate",
        helpers::messages::variant_predicate::sig,
    );
    fns.register_helper("field-getter", helpers::messages::field_getter::sig);

    fn fn_attributes(_: &GlobalContext) -> String {
        options().fn_attributes.to_string()
    }
    fns.register_helper("fn-attributes", fn_attributes);

    fn ns(_: &GlobalContext) -> String {
        GLOBAL_NS.to_string()
    }
    fns.register_helper("ns", ns);

    fn message_blob(_: &GlobalContext) -> String {
        options().diagnostic_message_blob_name.to_string()
    }
    fns.register_helper("message-blob", message_blob);

    template.render(ALL_DATA, &fns)
}
