use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__input_error", GLOBAL_NS)
}

pub fn input_error() -> String {
    format!(
        "
// InputError
{input_error_blob} {fn_attributes} {ns}__new_unsupported_encoding({string_ptr_blob} err_blob);
{input_error_blob} {fn_attributes} {ns}__new_decoding_error({string_ptr_blob} err_blob);
void {fn_attributes} {ns}__drop({input_error_blob}* self_blob);
bool {fn_attributes} {ns}__is_unsupported_encoding(const {input_error_blob}* self_blob);
bool {fn_attributes} {ns}__is_decoding_error(const {input_error_blob}* self_blob);
const {string_ptr_blob} *{fn_attributes} {ns}__get_unsupported_encoding(const {input_error_blob}* self_blob);
const {string_ptr_blob} *{fn_attributes} {ns}__get_decoding_error(const {input_error_blob}* self_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        input_error_blob = options().input_error_blob_name,
        string_ptr_blob = options().string_ptr_blob_name
    )
}
