use crate::{options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__bytes", GLOBAL_NS)
}

pub fn bytes() -> String {
    format!(
        "
// Bytes
{bytes_blob} {fn_attributes} {ns}__new({byte_list_blob} raw_blob);
void {fn_attributes} {ns}__drop({bytes_blob} *self_blob);
const {byte_list_blob} *{fn_attributes} {ns}__get_raw(const {bytes_blob} *self_blob);
void {fn_attributes} {ns}__set_raw({bytes_blob} *self_blob, {byte_list_blob} raw_blob);
{byte_list_blob} {fn_attributes} {ns}__into_raw({bytes_blob} self_blob);
void {fn_attributes} {ns}__push({bytes_blob} *self_blob, {byte_blob} byte_blob);
",
        ns = ns(),
        fn_attributes = options().fn_attributes,
        bytes_blob = options().bytes_blob_name,
        byte_list_blob = options().byte_list_blob_name,
        byte_blob = options().byte_blob_name
    )
}
