use crate::Options;
use lib_ruby_parser_nodes::{MessageField, MessageFieldType};

/// Returns name of the message field that is compatible with C
pub fn field_name(field: &MessageField) -> &str {
    match &field.name[..] {
        "operator" => "operator_",
        other => other,
    }
}

/// Returns type of the message field according to `options` configured by you
pub fn field_type(field: &MessageField, options: &Options) -> String {
    match field.field_type {
        MessageFieldType::Str => &options.string_ptr_blob_name,
        MessageFieldType::Byte => &options.byte_blob_name,
    }
    .to_owned()
}
