use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__string_ptr", GLOBAL_NS)
}

pub fn string_ptr(options: &Options) -> String {
    format!(
        "
// StringPtr
{string_ptr_blob} {fn_attributes} {ns}__new(uint8_t *ptr, uint64_t len);
void {fn_attributes} {ns}__drop({string_ptr_blob} *self_blob);
const uint8_t *{fn_attributes} {ns}__as_raw(const {string_ptr_blob} *self_blob);
uint8_t *{fn_attributes} {ns}__into_raw({string_ptr_blob} self_blob);
uint64_t {fn_attributes} {ns}__get_len(const {string_ptr_blob} *self_blob);
",
        ns = ns(),
        fn_attributes = options.fn_attributes,
        string_ptr_blob = options.string_ptr_blob_name
    )
}
