use super::ns;
use crate::Options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the cast-to-variant function for the given `node`
pub fn name(node: &Node) -> String {
    format!("{ns}__get_{lower}", ns = ns(), lower = node.lower_name())
}

/// Returns name of the cast-to-variant function for the given `node`
pub fn sig(node: &Node, options: &Options) -> String {
    format!(
        "{node_variant_blob} *{variant_getter_name}(Node_BLOB *blob)",
        node_variant_blob = options.node_variant_blob_name(node),
        variant_getter_name = name(node)
    )
}
