use super::{fields, ns};
use crate::Options;
use lib_ruby_parser_nodes::{Node, NodeField};

/// Returns name of the node field getter for the given `node`/`field` pair
pub fn name(node: &Node, field: &NodeField) -> String {
    format!(
        "{ns}__{lower}__get_{field_name}",
        ns = ns(),
        lower = node.lower_name(),
        field_name = field.field_name,
    )
}

/// Returns C signature of the node field getter for the given `node`/`field` pair
pub fn sig(node: &Node, field: &NodeField, options: &Options) -> String {
    format!(
        "{return_type} *{getter_name}({node_variant_blob} *blob)",
        return_type = fields::field_type(field, options),
        getter_name = name(node, field),
        node_variant_blob = options.node_variant_blob_name(node)
    )
}
