use super::{fields, ns};
use crate::Options;
use lib_ruby_parser_nodes::Node;

/// Returns name of the constructor for the given `node`
pub fn name(node: &Node) -> String {
    format!("{ns}__make_{lower}", ns = ns(), lower = node.lower_name())
}

fn arglist(node: &Node, options: &Options) -> String {
    node.fields
        .map(&|field| {
            format!(
                "{field_type} {name}",
                field_type = fields::field_type(field, options),
                name = fields::field_name(field)
            )
        })
        .join(", ")
}

/// Returns C signature of the constructor for the given `node`
pub fn sig(node: &Node, options: &Options) -> String {
    format!(
        "{node_blob} {constructor_name}({arglist})",
        constructor_name = name(node),
        node_blob = options.node_blob_name,
        arglist = arglist(node, options)
    )
}
