use super::{fields, ns};
use crate::Options;
use lib_ruby_parser_nodes::{Message, MessageField};

/// Returns name of the field getter for the given `message`/`field` pair
pub fn name(message: &Message, field: &MessageField) -> String {
    format!(
        "{ns}__{variant}__get_{field_name}",
        ns = ns(),
        variant = message.lower_name(),
        field_name = fields::field_name(field)
    )
}

/// Returns C signature of the field getter for the given `message`/`field` pair
pub fn sig(message: &Message, field: &MessageField, options: &Options) -> String {
    format!(
        "const {return_type} *{getter_name}(const {message_variant_blob} *blob)",
        return_type = fields::field_type(field, options),
        getter_name = name(message, field),
        message_variant_blob = options.message_variant_blob_name(message),
    )
}
