use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__string_ptr", GLOBAL_NS)
}

pub fn string_ptr(options: &Options) -> String {
    format!(
        "
// StringPtr
{string_ptr_blob} {ns}__new(const uint8_t *ptr, uint64_t len);
void {ns}__drop({string_ptr_blob} *blob);
uint8_t *{ns}__get_raw({string_ptr_blob} *blob);
uint64_t {ns}__get_len(const {string_ptr_blob} *blob);",
        ns = ns(),
        string_ptr_blob = options.string_ptr_blob_name
    )
}
