use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__maybe_string_ptr", GLOBAL_NS)
}

pub fn maybe_string_ptr(options: &Options) -> String {
    format!(
        "
// MaybeStringPtr
{maybe_string_ptr_blob} {ns}__new_some(const uint8_t *ptr, uint64_t len);
{maybe_string_ptr_blob} {ns}__new_none();
bool {ns}__is_some(const {maybe_string_ptr_blob} *blob);
bool {ns}__is_none(const {maybe_string_ptr_blob} *blob);
void {ns}__drop({maybe_string_ptr_blob} *blob);
uint8_t *{ns}__get_raw({maybe_string_ptr_blob} *blob);
uint8_t *{ns}__into_raw({maybe_string_ptr_blob} *blob);
uint64_t {ns}__len(const {maybe_string_ptr_blob} *blob);",
        ns = ns(),
        maybe_string_ptr_blob = options.maybe_string_ptr_blob_name
    )
}
