use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__loc", GLOBAL_NS)
}

pub fn loc(options: &Options) -> String {
    format!(
        "
// Loc
{loc_blob} {ns}__new(uint64_t begin, uint64_t end);
uint64_t {ns}__begin(const {loc_blob} *blob);
uint64_t {ns}__end(const {loc_blob} *blob);
void {ns}__drop({loc_blob} *blob);",
        ns = ns(),
        loc_blob = options.loc_blob_name
    )
}
