use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__diagnostic", GLOBAL_NS)
}

pub fn diagnostic(options: &Options) -> String {
    format!(
        "
// Diagnostic
{diagnostic_blob} {ns}__new({error_level_blob} level, {diagnostic_message_blob} message, {loc_blob} loc);
const {error_level_blob} *{ns}__get_level(const {diagnostic_blob} *blob);
const {diagnostic_message_blob} *{ns}__get_message(const {diagnostic_blob} *blob);
const {loc_blob} *{ns}__get_loc(const {diagnostic_blob} *blob);
void {ns}__drop({diagnostic_blob} *blob);",
        ns = ns(),
        diagnostic_blob = options.diagnostic_blob_name,
        error_level_blob = options.error_level_blob_name,
        diagnostic_message_blob = options.diagnostic_message_blob_name,
        loc_blob = options.loc_blob_name,
    )
}
