use crate::{Options, NS as GLOBAL_NS};

fn ns() -> String {
    format!("{}__comment_type", GLOBAL_NS)
}
pub fn comment_type(options: &Options) -> String {
    format!(
        "
// CommentType
{comment_type_blob} {ns}__new_inline();
{comment_type_blob} {ns}__new_document();
{comment_type_blob} {ns}__new_unknown();
bool {ns}__is_inline({comment_type_blob} blob);
bool {ns}__is_document({comment_type_blob} blob);
bool {ns}__is_unknown({comment_type_blob} blob);",
        ns = ns(),
        comment_type_blob = options.comment_type_blob_name
    )
}
