# lambda.rs

Utilities and macros for functional programming with closures

[![build status](https://api.travis-ci.org/epsilonz/lambda.rs.svg?branch=master)](https://travis-ci.org/epsilonz/lambda.rs)

## Synopsis

This library is a higher level counterpart to some of the [epsilonz](https://github.com/epsilonz) libraries such as [epsilonz/morphism.rs](https://github.com/epsilonz/morphism.rs).

## Examples

```rust
#[test]
fn test_example_readme() {
    use std::iter::AdditiveIterator;
    use std::num::Float;

    let f =
        λ!(| x | 2u64 * x)
        .o(| x | 1.5f64 + x.to_f64().unwrap())
        .o(| x | x.floor().to_u64().unwrap());
        
    let res = range(0u64, 9).map(f).sum();

    assert_eq!(res, 81);
}
```

## Documentation

See the API documentation [here](http://epsilonz.github.io/lambda.rs/doc/lambda/).

## Requirements

1.   [Rust](http://www.rust-lang.org/)
2.   [Cargo](http://crates.io/)

You can install both with the following:

```
$ curl -s https://static.rust-lang.org/rustup.sh | sudo sh
```

See [Installing Rust](http://doc.rust-lang.org/guide.html#installing-rust) for further details.

## Usage

```
$ cargo build       ## build library and binary
$ cargo test        ## run tests in ./tests
$ cargo bench       ## run benchmarks in ./benches
```

## Discussion

There is an IRC channel on [freenode](https://freenode.net) (chat.freenode.net) at [#epsilonz](http://webchat.freenode.net/?channels=%23epsilonz).
