/* automatically generated by rust-bindgen */

#[doc = " A slice over some data"]
#[repr(C)]
#[derive(Debug)]
pub struct slice_t {
	#[doc = " The data"]
	pub ptr: *const u8,
	#[doc = " The data length"]
	pub len: usize,
}
#[test]
fn bindgen_test_layout_slice_t() {
	assert_eq!(
		::core::mem::size_of::<slice_t>(),
		16usize,
		concat!("Size of: ", stringify!(slice_t))
	);
	assert_eq!(
		::core::mem::align_of::<slice_t>(),
		8usize,
		concat!("Alignment of ", stringify!(slice_t))
	);
	assert_eq!(
		unsafe { &(*(::core::ptr::null::<slice_t>())).ptr as *const _ as usize },
		0usize,
		concat!(
		"Offset of field: ",
		stringify!(slice_t),
		"::",
		stringify!(ptr)
		)
	);
	assert_eq!(
		unsafe { &(*(::core::ptr::null::<slice_t>())).len as *const _ as usize },
		8usize,
		concat!(
		"Offset of field: ",
		stringify!(slice_t),
		"::",
		stringify!(len)
		)
	);
}
#[doc = " A write callback"]
#[repr(C)]
#[derive(Debug)]
pub struct write_t {
	#[doc = " An opaque handle to the data sink"]
	pub handle: *mut ::std::os::raw::c_void,
	#[doc = " Pushes a segment to `handle` and returns `NULL` on success or a pointer to a static error"]
	#[doc = " description"]
	pub write: ::core::option::Option<
		unsafe extern "C" fn(
			handle: *mut ::std::os::raw::c_void,
			data: *const slice_t,
		) -> *const ::std::os::raw::c_char,
	>,
}
#[test]
fn bindgen_test_layout_write_t() {
	assert_eq!(
		::core::mem::size_of::<write_t>(),
		16usize,
		concat!("Size of: ", stringify!(write_t))
	);
	assert_eq!(
		::core::mem::align_of::<write_t>(),
		8usize,
		concat!("Alignment of ", stringify!(write_t))
	);
	assert_eq!(
		unsafe { &(*(::core::ptr::null::<write_t>())).handle as *const _ as usize },
		0usize,
		concat!(
		"Offset of field: ",
		stringify!(write_t),
		"::",
		stringify!(handle)
		)
	);
	assert_eq!(
		unsafe { &(*(::core::ptr::null::<write_t>())).write as *const _ as usize },
		8usize,
		concat!(
		"Offset of field: ",
		stringify!(write_t),
		"::",
		stringify!(write)
		)
	);
}
#[doc = " Initializes the library with a specific API version and a logging level"]
#[doc = ""]
#[doc = " \\param api The required API version"]
#[doc = " \\param log_level The stderr logging level to use"]
#[doc = " \\return `NULL` on success or a pointer to a static error description"]
pub type init = ::core::option::Option<
	unsafe extern "C" fn(api: u16, log_level: u8) -> *const ::std::os::raw::c_char,
>;
#[doc = " Queries the plugin/format ID"]
#[doc = ""]
#[doc = " \\param sink The sink to write the ID to"]
#[doc = " \\return `NULL` on success or a pointer to a static error description"]
pub type id = ::core::option::Option<
	unsafe extern "C" fn(sink: *mut write_t) -> *const ::std::os::raw::c_char,
>;
#[doc = " Queries all possible configs and writes them as separate segments"]
#[doc = ""]
#[doc = " \\param sink The sink to write the configs to (each config is a separate call to `write`)"]
#[doc = " \\return `NULL` on success or a pointer to a static error description"]
pub type configs = ::core::option::Option<
	unsafe extern "C" fn(sink: *mut write_t) -> *const ::std::os::raw::c_char,
>;
#[doc = " Sets an optional application specific context if supported (useful to assign better names etc.)"]
#[doc = ""]
#[doc = " \\param context The context to set"]
#[doc = " \\return `NULL` on success/if unsupported or a pointer to a static error description if a context"]
#[doc = "         is supported by the plugin but could not be set"]
pub type set_context = ::core::option::Option<
	unsafe extern "C" fn(context: *const slice_t) -> *const ::std::os::raw::c_char,
>;
#[doc = " Queries the authentication requirements to protect a secret for a specific config"]
#[doc = ""]
#[doc = " \\param is_required Is set to `1` if an authentication is required, `0` otherwise"]
#[doc = " \\param retries Is set to the amount of retries left or `UINT64_MAX` if there is no limit"]
#[doc = " \\param config The configuration to get the requirements for"]
#[doc = " \\return `NULL` on success or a pointer to a static error description"]
pub type auth_info_protect = ::core::option::Option<
	unsafe extern "C" fn(
		is_required: *mut u8,
		retries: *mut u64,
		config: *const slice_t,
	) -> *const ::std::os::raw::c_char,
>;
#[doc = " Queries the authentication requirements to recover a secret for a specific config"]
#[doc = ""]
#[doc = " \\param is_required Is set to `1` if an authentication is required, `0` otherwise"]
#[doc = " \\param retries Is set to the amount of retries left or `UINT64_MAX` if there is no limit"]
#[doc = " \\param config The configuration to get the requirements for"]
#[doc = " \\return `NULL` on success or a pointer to a static error description"]
pub type auth_info_recover = ::core::option::Option<
	unsafe extern "C" fn(
		is_required: *mut u8,
		retries: *mut u64,
		config: *const slice_t,
	) -> *const ::std::os::raw::c_char,
>;
#[doc = " Protects some data"]
#[doc = ""]
#[doc = " \\param sink The sink to write the recovery information to"]
#[doc = " \\param data The data to seal"]
#[doc = " \\param auth The authentication data (may be `NULL` if no authentication should be performed)"]
#[doc = " \\param config The config to use"]
#[doc = " \\return `NULL` on success or a pointer to a static error description"]
pub type protect = ::core::option::Option<
	unsafe extern "C" fn(
		sink: *mut write_t,
		data: *const slice_t,
		config: *const slice_t,
		auth: *const slice_t,
	) -> *const ::std::os::raw::c_char,
>;
#[doc = " Opens `data` to `sink` using `auth` and `config`"]
#[doc = ""]
#[doc = " \\param sink The sink to write the recovered data to"]
#[doc = " \\param data The recovery information"]
#[doc = " \\param auth The authentication data (may be `NULL` if no authentication should be performed)"]
#[doc = " \\return `NULL` on success or a pointer to a static error description"]
pub type recover = ::core::option::Option<
	unsafe extern "C" fn(
		sink: *mut write_t,
		data: *const slice_t,
		auth: *const slice_t,
	) -> *const ::std::os::raw::c_char,
>;