extern crate json_model;
#[macro_use]
extern crate serde_json;

use json_model::{Error, Validator};

fn document() -> serde_json::Value {
    json!({
        "id": "model",
        "definitions": [
            {
                "id": "user",
                "type": "object",
                "properties": {
                    "required": ["username", "password"],
                    "definitions": [
                        {
                            "id": "username",
                            "type": "string",
                            "minLength": 3,
                            "maxLength": 30,
                        },
                        {
                            "id": "password",
                            "type": "string",
                            "minLength": 5,
                            "maxLength": 256,
                        },
                        {
                            "id": "age",
                            "type": "integer",
                            "exclusiveMin": 0,
                            "max": 273,
                        }
                    ]
                }
            }
        ]
    })
}

fn valid_input() -> serde_json::Value {
    json!({
        "username": "johndoe",
        "password": "Tr0ub4dor&3",
        "age": 12,
    })
}

fn invalid_input() -> serde_json::Value {
    json!({
        "username": "johndoe",
        "password": "123", // `password` must be at least 5 characters long
    })
}

fn build() -> Result<Validator, Error> {
    Validator::new()?.load_json(&document())?.finalize()
}

fn main() {
    let v = build().unwrap();
    assert!(v.validate_json("model/user", &valid_input()).is_ok());
    assert!(v.validate_json("model/user", &invalid_input()).is_err());
}
