use crate::definition::Type;
use crate::validator::DocumentPath;

use std::collections::HashSet;

use serde_json;

#[derive(Debug)]
pub enum Error {
    ParseError(serde_json::Error),
    InvalidRoot,
    MissingAttribute {
        path: DocumentPath,
        attr: String,
    },
    InvalidValue {
        path: DocumentPath,
        value: serde_json::Value,
    },
    ForbiddenType {
        path: DocumentPath,
        typ: Type,
    },
    UnrecognizedAttribute {
        path: DocumentPath,
        attr: String,
    },
    UnknownType {
        path: DocumentPath,
        typ: String,
    },
    DuplicatePointer {
        path: DocumentPath,
        ptr: String,
    },
    DuplicateId {
        path: DocumentPath,
        id: String,
    },
    DuplicateName {
        path: DocumentPath,
        name: String,
    },
    // TODO: Check duplicate attributes when building attributes, etc.
    DuplicateAttribute {
        path: DocumentPath,
        attr: String,
    },
    UndefinedId {
        path: DocumentPath,
        id: String,
    },
    UnresolvedPointers {
        target: String,
        sources: HashSet<String>,
    },
}

#[derive(Debug)]
pub enum ValidationError {
    UndefinedDefinition,
    Failure {
        rule: String,
        path: Vec<String>,
        message: String,
    },
}
