use input_event_codes::*;

/// Event codes for absolute axes
#[derive(Clone, Copy, Debug, Eq, PartialEq)]
#[repr(u8)]
pub enum AbsoluteAxis {
	/// Left X axis
	LeftX = ABS_X,
	/// Left Y axis
	LeftY = ABS_Y,
	/// Left Z axis
	LeftZ = ABS_Z,
	/// Right X axis
	RightX = ABS_RX,
	/// Right Y axis
	RightY = ABS_RY,
	/// Right Z axis
	RightZ = ABS_RZ,
	/// Throttle axis
	Throttle = ABS_THROTTLE,
	/// Rudder axis
	Rudder = ABS_RUDDER,
	/// Wheel axis
	Wheel = ABS_WHEEL,
	/// Gas axis
	Gas = ABS_GAS,
	/// Break axis
	Break = ABS_BRAKE,
	/// Unknown axis 0B
	Unknown0B = 0x0b,
	/// Unknown axis 0C
	Unknown0C = 0x0c,
	/// Unknown axis 0D
	Unknown0D = 0x0d,
	/// Unknown axis 0E
	Unknown0E = 0x0e,
	/// Unknown axis 0F
	Unknown0F = 0x0f,
	/// Hat0 X axis
	Hat0X = ABS_HAT0X,
	/// Hat0 Y axis
	Hat0Y = ABS_HAT0Y,
	/// Hat1 X axis
	Hat1X = ABS_HAT1X,
	/// Hat1 Y axis
	Hat1Y = ABS_HAT1Y,
	/// Hat2 X axis
	Hat2X = ABS_HAT2X,
	/// Hat2 Y axis
	Hat2Y = ABS_HAT2Y,
	/// Hat3 X axis
	Hat3X = ABS_HAT3X,
	/// Hat3 Y axis
	Hat3Y = ABS_HAT3Y,
	/// Pressure axis
	Pressure = ABS_PRESSURE,
	/// Distance axis
	Distance = ABS_DISTANCE,
	/// Tilt X axis
	TiltX = ABS_TILT_X,
	/// Tilt Y axis
	TiltY = ABS_TILT_Y,
	/// Tool width axis
	ToolWidth = ABS_TOOL_WIDTH,
	/// Unknown axis 1D
	Unknown1D = 0x1d,
	/// Unknown axis 1E
	Unknown1E = 0x1e,
	/// Unknown axis 1F
	Unknown1F = 0x1f,
	/// Volume axis
	Volume = ABS_VOLUME,
	/// Unknown axis 21
	Unknown21 = 0x21,
	/// Unknown axis 22
	Unknown22 = 0x22,
	/// Unknown axis 23
	Unknown23 = 0x23,
	/// Unknown axis 24
	Unknown24 = 0x24,
	/// Unknown axis 25
	Unknown25 = 0x25,
	/// Unknown axis 26
	Unknown26 = 0x26,
	/// Unknown axis 27
	Unknown27 = 0x27,
	/// Miscellaneous axis
	Miscellaneous = ABS_MISC,
	/// Unknown axis 29
	Unknown29 = 0x29,
	/// Unknown axis 2A
	Unknown2A = 0x2a,
	/// Unknown axis 2B
	Unknown2B = 0x2b,
	/// Unknown axis 2C
	Unknown2C = 0x2c,
	/// Unknown axis 2D
	Unknown2D = 0x2d,
	/// Reserved axis
	Reserved = ABS_RESERVED,
	/// Multi-touch slot axis
	MultiTouchSlot = ABS_MT_SLOT,
	/// Multi-touch touch major axis
	MultiTouchTouchMajor = ABS_MT_TOUCH_MAJOR,
	/// Multi-touch touch minor axis
	MultiTouchTouchMinor = ABS_MT_TOUCH_MINOR,
	/// Multi-touch width major axis
	MultiTouchWidthMajor = ABS_MT_WIDTH_MAJOR,
	/// Multi-touch width minor axis
	MultiTouchWidthMinor = ABS_MT_WIDTH_MINOR,
	/// Multi-touch orientation axis
	MultiTouchOrientation = ABS_MT_ORIENTATION,
	/// Multi-touch position X axis
	MultiTouchPositionX = ABS_MT_POSITION_X,
	/// Multi-touch position Y axis
	MultiTouchPositionY = ABS_MT_POSITION_Y,
	/// Multi-touch tool type axis
	MultiTouchToolType = ABS_MT_TOOL_TYPE,
	/// Multi-touch blob id axis
	MultiTouchBlobId = ABS_MT_BLOB_ID,
	/// Multi-touch tracking id axis
	MultiTouchTrackingId = ABS_MT_TRACKING_ID,
	/// Multi-touch pressure axis
	MultiTouchPressure = ABS_MT_PRESSURE,
	/// Multi-touch distance axis
	MultiTouchDistance = ABS_MT_DISTANCE,
	/// Multi-touch tool X axis
	MultiTouchToolX = ABS_MT_TOOL_X,
	/// Multi-touch tool Y axis
	MultiTouchToolY = ABS_MT_TOOL_Y,
	/// Unknown axis 3E
	Unknown3E = 0x3e,
	/// Maximum value
	Max = ABS_MAX,
	/// Axis count
	Count = ABS_CNT,
}

impl Default for AbsoluteAxis {
	fn default() -> Self {
		AbsoluteAxis::LeftX
	}
}
