use input_event_codes::*;

#[derive(Clone, Copy, Debug, Eq, PartialEq)]
#[repr(u8)]
pub enum AbsoluteAxis {
	X = ABS_X,
	Y = ABS_Y,
	Z = ABS_Z,
	RX = ABS_RX,
	RY = ABS_RY,
	RZ = ABS_RZ,
	Throttle = ABS_THROTTLE,
	Rudder = ABS_RUDDER,
	Wheel = ABS_WHEEL,
	Gas = ABS_GAS,
	Break = ABS_BRAKE,
	Unknown0B = 0x0b,
	Unknown0C = 0x0c,
	Unknown0D = 0x0d,
	Unknown0E = 0x0e,
	Unknown0F = 0x0f,
	Hat0X = ABS_HAT0X,
	Hat0Y = ABS_HAT0Y,
	Hat1X = ABS_HAT1X,
	Hat1Y = ABS_HAT1Y,
	Hat2X = ABS_HAT2X,
	Hat2Y = ABS_HAT2Y,
	Hat3X = ABS_HAT3X,
	Hat3Y = ABS_HAT3Y,
	Pressure = ABS_PRESSURE,
	Distance = ABS_DISTANCE,
	TiltX = ABS_TILT_X,
	TiltY = ABS_TILT_Y,
	ToolWidth = ABS_TOOL_WIDTH,
	Unknown1D = 0x1d,
	Unknown1E = 0x1e,
	Unknown1F = 0x1f,
	Volume = ABS_VOLUME,
	Unknown21 = 0x21,
	Unknown22 = 0x22,
	Unknown23 = 0x23,
	Unknown24 = 0x24,
	Unknown25 = 0x25,
	Unknown26 = 0x26,
	Unknown27 = 0x27,
	Misc = ABS_MISC,
	Unknown29 = 0x29,
	Unknown2A = 0x2a,
	Unknown2B = 0x2b,
	Unknown2C = 0x2c,
	Unknown2D = 0x2d,
	Reserved = ABS_RESERVED,
	MultiTouchSlot = ABS_MT_SLOT,
	MultiTouchTouchMajor = ABS_MT_TOUCH_MAJOR,
	MultiTouchTouchMinor = ABS_MT_TOUCH_MINOR,
	MultiTouchWidthMajor = ABS_MT_WIDTH_MAJOR,
	MultiTouchWidthMinor = ABS_MT_WIDTH_MINOR,
	MultiTouchOrientation = ABS_MT_ORIENTATION,
	MultiTouchPositionX = ABS_MT_POSITION_X,
	MultiTouchPositionY = ABS_MT_POSITION_Y,
	MultiTouchToolType = ABS_MT_TOOL_TYPE,
	MultiTouchBlobId = ABS_MT_BLOB_ID,
	MultiTouchTrackingId = ABS_MT_TRACKING_ID,
	MultiTouchPressure = ABS_MT_PRESSURE,
	MultiTouchDistance = ABS_MT_DISTANCE,
	MultiTouchToolX = ABS_MT_TOOL_X,
	MultiTouchToolY = ABS_MT_TOOL_Y,
	Unknown3E = 0x3e,
	Max = ABS_MAX,
	Cnt = ABS_CNT,
}

impl Default for AbsoluteAxis {
	fn default() -> Self {
		AbsoluteAxis::X
	}
}
