use crate::event_codes::KeyOrButton;
use crate::GenericEvent;

#[derive(Clone, Copy, Debug)]
pub struct ButtonEvent {
	button: KeyOrButton,
	is_synthetic: bool,
	time: u32,
	value: i16,
}

impl ButtonEvent {
	pub const fn button(&self) -> KeyOrButton {
		self.button
	}

	pub(crate) const fn new(button: KeyOrButton, is_synthetic: bool, time: u32, value: i16) -> Self {
		ButtonEvent {
			button,
			is_synthetic,
			time,
			value,
		}
	}
}

impl GenericEvent for ButtonEvent {
	fn is_real(&self) -> bool {
		!self.is_synthetic
	}

	fn is_synthetic(&self) -> bool {
		self.is_synthetic
	}

	fn time(&self) -> u32 {
		self.time
	}

	fn value(&self) -> i16 {
		self.value
	}
}
